Background = class()

function Background:created(size, color1, color2)
    -- you can accept and set parameters here
    local orthoY = scene.main.camera:get(camera).orthoSize
    
    self.checkers = shader.builder()
    :unlit()
    :vec2{"size", value = vec2(10, 10)}
    :color{"colorA", value = color.black}
    :color{"colorB", value = color.white}
    :vec2{"resolution", value = vec2(orthoY* ((WIDTH + 0.0)/HEIGHT), orthoY)}
    :material
    [[
    vec2 uv = getUV0();
    uv.x = uv.x / (resolution.y / resolution.x);
    uv = floor(uv * size);
    float c = mod(uv.x + uv.y, 2);
    material.baseColor = mix(colorA, colorB, c);
]]
:build()
    
    self.size = size
    self.color1 = color1
    self.color2 = color2
    
    self.checkers.size =  self.size
    self.checkers.colorA =  self.color1
    self.checkers.colorB =  self.color2
    
    
end

function Background:draw()
    local orthoY = scene.main.camera:get(camera).orthoSize
    self.checkers.size =  self.size
    self.checkers.colorA =  self.color1
    self.checkers.colorB =  self.color2
    self.checkers.resolution = vec2(orthoY* ((WIDTH + 0.0)/HEIGHT), orthoY)
        
    
    sprite(self.checkers, 0, 0, orthoY* ((WIDTH + 0.0)/HEIGHT), orthoY)
end

function Background:touched(touch)
    -- Codea does not automatically call this method
end
